/**
* \file: AilAudioSource.cpp
*
* \version: $Id:$
*
* \release: $Name:$
*
* Audio source endpoint implementation using AIL
*
* \component: Baidu CarLife
*
* \author: P. Govindaraju / RBEB/GM / Pradeepa.Govindaraju@in.bosch.com
*          P. Acar / ADIT/SW2 / pacar@de.adit-jv.com
*
* \copyright (c) 2016-2017 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#include <AilAudioSource.h>
#include "AilAudioSourceImpl.h"

namespace adit { namespace bdcl {
using std::string;
using std::unique_ptr;

AilAudioSource::AilAudioSource(IAditAudioSourceCallbacks* inCallbacks, CoreCallbackDealer* inCallbackDealer)
: AditAudioSource(inCallbacks, inCallbackDealer)
{
    impl = move(unique_ptr<AilAudioSourceImpl>(new AilAudioSourceImpl(inCallbacks, inCallbackDealer)));
}

AilAudioSource::~AilAudioSource() { }

void AilAudioSource::setConfigItem(string inKey, string inValue)
{
    impl->setConfigItem(inKey, inValue);
}

bool AilAudioSource::initialize()
{
    return impl->initialize();
}

void AilAudioSource::teardown()
{
    impl->teardown();
}

bool AilAudioSource::captureStart()
{
    return impl->captureStart();
}

bool AilAudioSource::captureStop()
{
    return impl->captureStop();
}

} } /* namespace adit { namespace bdcl { */




